# Guidelines for Prompting

In this lesson, you will explore key principles and tactics for crafting effective prompts for large language models (LLMs).

## Prompting Principles

### Principle 1: Write Clear and Specific Instructions

When creating prompts, clarity is crucial. Providing explicit and detailed instructions helps guide the model to generate the desired output. It’s important to remember that a longer prompt can offer more context, resulting in better responses.

**Example:**  
Instead of saying, "Tell me about dogs," you might say, "Describe three popular dog breeds, including their characteristics and typical behavior."

### Principle 2: Allow the Model Time to “Think”

Giving the model time to process can lead to more accurate and thoughtful responses.

#### Tactic 1: Specify Required Steps

Clearly outline the steps necessary to complete a task. This helps structure the model's thinking.

**Example:**  
"Please summarize the following passage in one sentence, translate that sentence into Spanish, and then identify any proper nouns mentioned."

## Tactics for Effective Prompting

#### Tactic 1: Use Delimiters

Delimiters can help indicate different parts of your input, enhancing clarity. They can be any type of marker such as brackets, quotes, or special characters.

**Example:**  
"Summarize the following text enclosed in triple quotes:  
\"\"\"The history of art spans many centuries and cultures...\"\"\""

#### Tactic 2: Request Structured Outputs

Encouraging structured responses can facilitate better organization of information.

**Example:**  
"Create a list of three fictional movie titles with their respective genres and release years in a tabular format."

#### Tactic 3: Check for Conditions

Ask the model to verify whether specific conditions are met in the text.

**Example:**  
"If the text describes a recipe, outline the steps clearly. If not, respond with 'No recipe found.'"

### Principle 2: Encourage Thoughtful Processing

#### Tactic 1: Specify Output Format

Instruct the model to produce output in a particular format, which aids in clarity.

**Example:**  
"Summarize the following article and present the summary in bullet points, followed by a short analysis of its main argument."

#### Tactic 2: Encourage the Model to Solve Problems First

Instruct the model to think through a problem before evaluating a provided solution.

**Example:**  
"Calculate the total cost of a project involving X number of units, then compare your solution with the following student’s answer to assess correctness."

### Next Topic > [Iterative Prompt](https://github.com/Riddhish97/PromptResources/blob/main/Prompt%20Eng%20advanced%20examples/Iterative%20Prompt.md)
